    ;*************************************************************************
	; file: timers.asm
	;		Contains the code to manage the two timer modules, timer0 and 
	;		timer1
	;*************************************************************************


    ;*************************************************************************
	; include files go here
	;*************************************************************************

    include <P18f27J13.INC>


	;*************************************************************************
	; extern directives - to gain access to global functions and data from 
	;					  elsewhere
	;*************************************************************************


	;*************************************************************************
	; global directives - making variables and functions available elsewhere -
	;					  go here
	;*************************************************************************

	global  usleep
	global  Timer0Init
	global  Timer1Init


	;*************************************************************************
	; Constanst - Symbolic constants and simple macros, defined with the 
	;			  EQU directive, go here.
	;*************************************************************************

	; TMR0 configuration for our usleep delay routine
	; The configuration is so simple we do not need an
	; initialisation routine
	TMR0_DISABLE	EQU	0x00
	TMR0_ENABLE		EQU	0x83
	TMR1_CONF 		EQU 0x8E	      ; timer is 16bit, TMR1 SOC source, prescale by 1 (None)


	;*************************************************************************
	; Definition of RAM based variables follow the udata directive
	;*************************************************************************

	udata


	;*************************************************************************
	; code, such as functions and ROM based data tables, follow the code directive
	;*************************************************************************

	code
	
	;*************************************************************************
	; Function: usleep
	;			A delay routine providing approximate microsecond delays, 
	;			mainly for the LCD module. Uses timer0
	; 			TMR0 will have been loaded before calling.
	;*************************************************************************
usleep:
	bcf		INTCON, TMR0IF
	movlw	TMR0_ENABLE
	movwf	T0CON
usl001:
	btfss	INTCON, TMR0IF
	goto	usl001
	movlw	TMR0_DISABLE
	movwf	T0CON

	return


	;*************************************************************************
	; Function: Timer0Init
	;			Initialises timer0, ensuring it is turned off
	;*************************************************************************
Timer0Init
	movlw	TMR0_DISABLE
	movwf	T0CON

	return


	;*************************************************************************
	; Function: Timer1Init
	;			Enables Timer1 based on the attached 32KHz oscillator.
	;			This timer setup is special; it is accurate ( being based off 
	;			a crystal ) and it is used to periodically wake the processor 
	;			from sleep mode ( if the sleep instruction is used )
	;*************************************************************************
Timer1Init
	bcf 	PIR1, TMR1IF
	clrf	TMR1H
	movlw	0
	clrf	TMR1L

	; Enable the 32KHz oscillator on Timer1
	; for use as an accurate timebase.
	movlw	TMR1_CONF
	movwf	T1CON	 	
	bsf     PIE1, TMR1IE
	bsf		INTCON, PEIE
	bsf		INTCON, GIE
	bsf		T1CON, TMR1ON

	return


	end
