	;*************************************************************************
	; file: hardware.asm
	;		Contains code to handle various hardware features not tied
	;		to any specific peripheral feature
	;*************************************************************************


    ;*************************************************************************
	; include files go here
	;*************************************************************************

    include <P18f27J13.INC>
	include <macros.inc>


	;*************************************************************************
	; extern directives - to gain access to global functions and data from 
	;					  elsewhere
	;*************************************************************************


	;*************************************************************************
	; global directives - making variables and functions available elsewhere -
	;					  go here
	;*************************************************************************

	global 	HardwareInit


	;*************************************************************************
	; Constanst - Symbolic constants and simple macros, defined with the 
	;			  EQU directive, go here.
	;*************************************************************************


	;*************************************************************************
	; Definition of RAM based variables follow the udata directive
	;*************************************************************************

	udata

	;*************************************************************************
	; code, such as functions and ROM based data tables, follow the code directive
	;*************************************************************************

	code

	;*************************************************************************
	; Function: HardwareInit
	;			Initialises any hardware features not tied to a specific 
	;			peripheral
	;*************************************************************************
HardwareInit:

	return
	

	end
