	;*************************************************************************
	; file: hardware.asm
	;		Contains code to handle various hardware features not tied
	;		to any specific peripheral feature
	;*************************************************************************


    ;*************************************************************************
	; include files go here
	;*************************************************************************

    include <P18f27J13.INC>
	include <macros.inc>


	;*************************************************************************
	; extern directives - to gain access to global functions and data from 
	;					  elsewhere
	;*************************************************************************


	;*************************************************************************
	; global directives - making variables and functions available elsewhere -
	;					  go here
	;*************************************************************************

	global 	HardwareInit


	;*************************************************************************
	; Constanst - Symbolic constants and simple macros, defined with the 
	;			  EQU directive, go here.
	;*************************************************************************


	;*************************************************************************
	; Definition of RAM based variables follow the udata directive
	;*************************************************************************

	udata

	;*************************************************************************
	; code, such as functions and ROM based data tables, follow the code directive
	;*************************************************************************

	code


	;*************************************************************************
	; Function: HardwareInit
	;			Initialises any hardware features not tied to a specific 
	;			peripheral
	;*************************************************************************
HardwareInit:

	; Set our shared pins to digital I/O pins
	movlb	0x0F
  	movlw  	0xFF
   	movwf  	ANCON0
   	movlw  	0x17
   	movwf  	ANCON1
	movlb	0

	bcf		TRISB, 5	; LED pin to be an output

	bsf		TRISC, 3	; PWM pin must be an output to hear the sound. Thsi turns it off.
	movlb	.14
	movlw	.14
	movwf	RPOR14		; put P1A PWM signal on pin RP14

	movlb	.15
	movlw	.0
	movwf	CCPTMRS0
	clrf	BSR
	movlw	.60
	movwf	CCP1CON

	movlw	.94			; Gives 125us at 12MHz/16 input clock to timer2
	movwf	CCPR1L

	movlw	.188
	movwf	PR2			; Gives 250us at 12MHz/16 input clock to timer2


	movlw	.6			; Timer2 on, divide by 16 prescaler
	movwf	T2CON


	return
	

	end
